<div class="front_page_section front_page_section_googlemap<?php
	$resurs_scheme = resurs_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $resurs_scheme ) && ! resurs_is_inherit( $resurs_scheme ) ) {
		echo ' scheme_' . esc_attr( $resurs_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( resurs_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( resurs_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$resurs_css      = '';
		$resurs_bg_image = resurs_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $resurs_bg_image ) ) {
			$resurs_css .= 'background-image: url(' . esc_url( resurs_get_attachment_url( $resurs_bg_image ) ) . ');';
		}
		if ( ! empty( $resurs_css ) ) {
			echo ' style="' . esc_attr( $resurs_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$resurs_anchor_icon = resurs_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$resurs_anchor_text = resurs_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $resurs_anchor_icon ) || ! empty( $resurs_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $resurs_anchor_icon ) ? ' icon="' . esc_attr( $resurs_anchor_icon ) . '"' : '' )
									. ( ! empty( $resurs_anchor_text ) ? ' title="' . esc_attr( $resurs_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$resurs_layout = resurs_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $resurs_layout );
		if ( resurs_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' resurs-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$resurs_css      = '';
			$resurs_bg_mask  = resurs_get_theme_option( 'front_page_googlemap_bg_mask' );
			$resurs_bg_color_type = resurs_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_scheme_color( 'bg_color', $resurs_scheme );
			} else {
				$resurs_bg_color = '';
			}
			if ( ! empty( $resurs_bg_color ) && $resurs_bg_mask > 0 ) {
				$resurs_css .= 'background-color: ' . esc_attr(
					1 == $resurs_bg_mask ? $resurs_bg_color : resurs_hex2rgba( $resurs_bg_color, $resurs_bg_mask )
				) . ';';
			}
			if ( ! empty( $resurs_css ) ) {
				echo ' style="' . esc_attr( $resurs_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $resurs_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$resurs_caption     = resurs_get_theme_option( 'front_page_googlemap_caption' );
			$resurs_description = resurs_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $resurs_caption ) || ! empty( $resurs_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $resurs_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $resurs_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $resurs_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $resurs_caption, 'resurs_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $resurs_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $resurs_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $resurs_description ), 'resurs_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $resurs_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$resurs_content = resurs_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $resurs_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $resurs_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $resurs_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $resurs_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $resurs_content, 'resurs_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $resurs_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $resurs_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! resurs_exists_trx_addons() ) {
						resurs_customizer_need_trx_addons_message();
					} else {
						resurs_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $resurs_layout && ( ! empty( $resurs_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
