<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_template = apply_filters( 'resurs_filter_get_template_part', resurs_blog_archive_get_template() );

if ( ! empty( $resurs_template ) && 'index' != $resurs_template ) {

	get_template_part( $resurs_template );

} else {

	resurs_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$resurs_stickies   = is_home()
								|| ( in_array( resurs_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) resurs_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$resurs_post_type  = resurs_get_theme_option( 'post_type' );
		$resurs_args       = array(
								'blog_style'     => resurs_get_theme_option( 'blog_style' ),
								'post_type'      => $resurs_post_type,
								'taxonomy'       => resurs_get_post_type_taxonomy( $resurs_post_type ),
								'parent_cat'     => resurs_get_theme_option( 'parent_cat' ),
								'posts_per_page' => resurs_get_theme_option( 'posts_per_page' ),
								'sticky'         => resurs_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $resurs_stickies )
															&& count( $resurs_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		resurs_blog_archive_start();

		do_action( 'resurs_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'resurs_action_before_page_author' );
			get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'resurs_action_after_page_author' );
		}

		if ( resurs_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'resurs_action_before_page_filters' );
			resurs_show_filters( $resurs_args );
			do_action( 'resurs_action_after_page_filters' );
		} else {
			do_action( 'resurs_action_before_page_posts' );
			resurs_show_posts( array_merge( $resurs_args, array( 'cat' => $resurs_args['parent_cat'] ) ) );
			do_action( 'resurs_action_after_page_posts' );
		}

		do_action( 'resurs_action_blog_archive_end' );

		resurs_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
