<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package RESURS
 * @since RESURS 1.0
 */

if ( resurs_sidebar_present() ) {
	
	$resurs_sidebar_type = resurs_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $resurs_sidebar_type && ! resurs_is_layouts_available() ) {
		$resurs_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $resurs_sidebar_type ) {
		// Default sidebar with widgets
		$resurs_sidebar_name = resurs_get_theme_option( 'sidebar_widgets' );
		resurs_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $resurs_sidebar_name ) ) {
			dynamic_sidebar( $resurs_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$resurs_sidebar_id = resurs_get_custom_sidebar_id();
		do_action( 'resurs_action_show_layout', $resurs_sidebar_id );
	}
	$resurs_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $resurs_out ) ) {
		$resurs_sidebar_position    = resurs_get_theme_option( 'sidebar_position' );
		$resurs_sidebar_position_ss = resurs_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $resurs_sidebar_position );
			echo ' sidebar_' . esc_attr( $resurs_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $resurs_sidebar_type );

			$resurs_sidebar_scheme = apply_filters( 'resurs_filter_sidebar_scheme', resurs_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $resurs_sidebar_scheme ) && ! resurs_is_inherit( $resurs_sidebar_scheme ) && 'custom' != $resurs_sidebar_type ) {
				echo ' scheme_' . esc_attr( $resurs_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="resurs_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'resurs_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $resurs_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$resurs_title = apply_filters( 'resurs_filter_sidebar_control_title', 'float' == $resurs_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'resurs' ) : '' );
				$resurs_text  = apply_filters( 'resurs_filter_sidebar_control_text', 'above' == $resurs_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'resurs' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $resurs_title ); ?>"><?php echo esc_html( $resurs_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'resurs_action_before_sidebar', 'sidebar' );
				resurs_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $resurs_out ) );
				do_action( 'resurs_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'resurs_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
