<?php
/**
 * Skin Setup
 *
 * @package RESURS
 * @since RESURS 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'resurs_theme_defaults' ) ) {
	function resurs_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'resurs_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'resurs_filter_load_woocommerce_extensions', 'resurs_skin_woocommerce_allow_extensions' );
	function resurs_skin_woocommerce_allow_extensions( $allow ) {
		return false;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'resurs_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'resurs_skin_setup', 1 );
	function resurs_skin_setup() {

		$GLOBALS['RESURS_STORAGE'] = array_merge( $GLOBALS['RESURS_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-themerex',

			'theme_doc_url'       => '//doc.themerex.net/resurs/',

			'theme_demofiles_url' => '//demofiles.themerex.net/resurs/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/themerex/portfolio',								// ThemeREX

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',						// ThemeREX

			'theme_privacy_url'   => '//themerex.net/privacy-policy/',											// ThemeREX

			'portfolio_url'       => '//themeforest.net/user/themerex/portfolio',								// ThemeREX

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'resurs_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'resurs_skin_setup_settings', 1 );
	function resurs_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		resurs_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		resurs_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', false );
		resurs_storage_set_array2( 'required_plugins', 'quickcal', 'install', true );
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'resurs_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'resurs_skin_setup_fonts', 1 );
	function resurs_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		resurs_storage_set(
			'load_fonts', array(
                // Google fonts
				array(
					'name'   => 'Marcellus',
					'family' => 'serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;1,400',     // Parameter 'style' used only for the Google fonts
				),
                array(
					'name'   => 'DM Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;0,500;0,700;1,400;1,500;1,700',     // Parameter 'style' used only for the Google fonts
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		resurs_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => resurs_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'resurs' );

		resurs_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'resurs' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.7em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.6em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'resurs' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '3.353em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1.8px',
					'margin-top'      => '1.08em',
					'margin-bottom'   => '0.4em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '2.765em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.1px',
					'margin-top'      => '0.74em',
					'margin-bottom'   => '0.5em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '2.059em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.94em',
					'margin-bottom'   => '0.62em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.647em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.15em',
					'margin-bottom'   => '0.6em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.412em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.3em',
					'margin-bottom'   => '0.65em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.118em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.75em',
					'margin-bottom'   => '1.08em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.6em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '20px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'resurs' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'resurs' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '17px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'resurs' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'resurs' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'resurs' ) ),
					'font-family'     => 'Marcellus,serif',
				),
			)
		);

		// Font presets
		resurs_storage_set(
			'font_presets', array(
				'karla' => array(
					'title'  => esc_html__( 'Karla', 'resurs' ),
					'load_fonts' => array(
						// Google font
						array(
							'name'   => 'Dancing Script',
							'family' => 'fantasy',
							'link'   => '',
							'styles' => '300,400,700',
						),
						// Google font
						array(
							'name'   => 'Sansita Swashed',
							'family' => 'fantasy',
							'link'   => '',
							'styles' => '300,400,700',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Dancing Script",fantasy',
							'font-size'       => '1.25rem',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
							'font-size'       => '4em',
						),
						'h2'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h3'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h4'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h5'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h6'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'logo'    => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'button'  => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'submenu' => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
					),
				),
				'roboto' => array(
					'title'  => esc_html__( 'Roboto', 'resurs' ),
					'load_fonts' => array(
						// Google font
						array(
							'name'   => 'Noto Sans JP',
							'family' => 'serif',
							'link'   => '',
							'styles' => '300,300italic,400,400italic,700,700italic',
						),
						// Google font
						array(
							'name'   => 'Merriweather',
							'family' => 'sans-serif',
							'link'   => '',
							'styles' => '300,300italic,400,400italic,700,700italic',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Noto Sans JP",serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
					),
				),
				'garamond' => array(
					'title'  => esc_html__( 'Garamond', 'resurs' ),
					'load_fonts' => array(
						// Adobe font
						array(
							'name'   => 'Europe',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
						// Adobe font
						array(
							'name'   => 'Sofia Pro',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Sofia Pro",sans-serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Europe,sans-serif',
						),
					),
				),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'resurs_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'resurs_skin_setup_schemes', 1 );
	function resurs_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		resurs_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'resurs' ),
					'description' => esc_html__( 'Colors of the main content area', 'resurs' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'resurs' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'resurs' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'resurs' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'resurs' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'resurs' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'resurs' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'resurs' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'resurs' ),
				),
			)
		);

		resurs_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'resurs' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'resurs' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'resurs' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'resurs' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'resurs' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'resurs' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'resurs' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'resurs' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'resurs' ),
					'description' => esc_html__( 'Color of the text inside this block', 'resurs' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'resurs' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'resurs' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'resurs' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'resurs' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'resurs' ),
					'description' => esc_html__( 'Color of the links inside this block', 'resurs' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'resurs' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'resurs' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'resurs' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'resurs' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'resurs' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'resurs' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'resurs' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'resurs' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'resurs' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'resurs' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F9F7F6',
					'bd_color'         => '#D4D4D4',

					// Text and links colors
					'text'             => '#80837D',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#282E24',
					'text_link'        => '#909C87',
					'text_hover'       => '#86927D',
					'text_link2'       => '#D3A294',
					'text_hover2'      => '#C79182',
					'text_link3'       => '#A475B1',
					'text_hover3'      => '#965FA5',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF',
					'alter_bg_hover'   => '#EBEBEB',
					'alter_bd_color'   => '#D4D4D4',
					'alter_bd_hover'   => '#CDCDCD',
					'alter_text'       => '#80837D',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#282E24',
					'alter_link'       => '#909C87',
					'alter_hover'      => '#86927D',
					'alter_link2'      => '#D3A294',
					'alter_hover2'     => '#C79182',
					'alter_link3'      => '#A475B1',
					'alter_hover3'     => '#965FA5',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#909C87',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D4D4D4',
					'input_bd_hover'   => '#CDCDCD',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#282E24',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D6D6D6',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#282E24',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'light'
			'light' => array(
				'title'    => esc_html__( 'Light', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF',
					'bd_color'         => '#D4D4D4',

					// Text and links colors
					'text'             => '#80837D',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#282E24',
					'text_link'        => '#909C87',
					'text_hover'       => '#86927D',
					'text_link2'       => '#D3A294',
					'text_hover2'      => '#C79182',
					'text_link3'       => '#A475B1',
					'text_hover3'      => '#965FA5',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F9F7F6',
					'alter_bg_hover'   => '#EBEBEB',
					'alter_bd_color'   => '#D4D4D4',
					'alter_bd_hover'   => '#CDCDCD',
					'alter_text'       => '#80837D',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#282E24',
					'alter_link'       => '#909C87',
					'alter_hover'      => '#86927D',
					'alter_link2'      => '#D3A294',
					'alter_hover2'     => '#C79182',
					'alter_link3'      => '#A475B1',
					'alter_hover3'     => '#965FA5',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#909C87',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D4D4D4',
					'input_bd_hover'   => '#CDCDCD',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#282E24',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D6D6D6',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#282E24',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#222322',
					'bd_color'         => '#373837',

					// Text and links colors
					'text'             => '#D6D6D6',
					'text_light'       => '#A2A4A2',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#909C87',
					'text_hover'       => '#86927D',
					'text_link2'       => '#D3A294',
					'text_hover2'      => '#C79182',
					'text_link3'       => '#A475B1',
					'text_hover3'      => '#965FA5',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1A1B19',
					'alter_bg_hover'   => '#383D4B',
					'alter_bd_color'   => '#373837',
					'alter_bd_hover'   => '#373837',
					'alter_text'       => '#D6D6D6',
					'alter_light'      => '#A2A4A2',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#909C87',
					'alter_hover'      => '#86927D',
					'alter_link2'      => '#D3A294',
					'alter_hover2'     => '#C79182',
					'alter_link3'      => '#A475B1',
					'alter_hover3'     => '#965FA5',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#909C87',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#373837',
					'input_bd_hover'   => '#454545',
					'input_text'       => '#D6D6D6',
					'input_light'      => '#D6D6D6',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#282E24',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#282E24',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark_light'
			'dark_light'    => array(
				'title'    => esc_html__( 'Dark Light', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#1A1B19',
					'bd_color'         => '#373837',

					// Text and links colors
					'text'             => '#D6D6D6',
					'text_light'       => '#A2A4A2',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#909C87',
					'text_hover'       => '#86927D',
					'text_link2'       => '#D3A294',
					'text_hover2'      => '#C79182',
					'text_link3'       => '#A475B1',
					'text_hover3'      => '#965FA5',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#222322',
					'alter_bg_hover'   => '#383D4B',
					'alter_bd_color'   => '#373837',
					'alter_bd_hover'   => '#373837',
					'alter_text'       => '#D6D6D6',
					'alter_light'      => '#A2A4A2',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#909C87',
					'alter_hover'      => '#86927D',
					'alter_link2'      => '#D3A294',
					'alter_hover2'     => '#C79182',
					'alter_link3'      => '#A475B1',
					'alter_hover3'     => '#965FA5',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#909C87',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#373837',
					'input_bd_hover'   => '#454545',
					'input_text'       => '#D6D6D6',
					'input_light'      => '#D6D6D6',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#282E24',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#282E24',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'extra_default'
			'extra_default' => array(
				'title'    => esc_html__( 'Extra Default', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FDF8F4',
					'bd_color'         => '#E4DDD7',

					// Text and links colors
					'text'             => '#858280',
					'text_light'       => '#B8B8B8',
					'text_dark'        => '#1C1B1B',
					'text_link'        => '#FEB58C',
					'text_hover'       => '#F0A377',
					'text_link2'       => '#ED6954',
					'text_hover2'      => '#DA533E',
					'text_link3'       => '#ADB5F4',
					'text_hover3'      => '#99A2EE',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF',
					'alter_bg_hover'   => '#F4EBE0',
					'alter_bd_color'   => '#E4DDD7',
					'alter_bd_hover'   => '#DED6CE',
					'alter_text'       => '#858280',
					'alter_light'      => '#B8B8B8',
					'alter_dark'       => '#1C1B1B',
					'alter_link'       => '#FEB58C',
					'alter_hover'      => '#F0A377',
					'alter_link2'      => '#ED6954',
					'alter_hover2'     => '#DA533E',
					'alter_link3'      => '#ADB5F4',
					'alter_hover3'     => '#99A2EE',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#F8F5EF',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#FEB58C',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E4DDD7',
					'input_bd_hover'   => '#DED6CE',
					'input_text'       => '#B8B8B8',
					'input_light'      => '#B8B8B8',
					'input_dark'       => '#1C1B1B',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#DBD4D4',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1C1B1B',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'extra_light'
			'extra_light' => array(
				'title'    => esc_html__( 'Extra Light', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF',
					'bd_color'         => '#E4DDD7',

					// Text and links colors
					'text'             => '#858280',
					'text_light'       => '#B8B8B8',
					'text_dark'        => '#1C1B1B',
					'text_link'        => '#FEB58C',
					'text_hover'       => '#F0A377',
					'text_link2'       => '#ED6954',
					'text_hover2'      => '#DA533E',
					'text_link3'       => '#ADB5F4',
					'text_hover3'      => '#99A2EE',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FDF8F4',
					'alter_bg_hover'   => '#F4EBE0',
					'alter_bd_color'   => '#E4DDD7',
					'alter_bd_hover'   => '#DED6CE',
					'alter_text'       => '#858280',
					'alter_light'      => '#B8B8B8',
					'alter_dark'       => '#1C1B1B',
					'alter_link'       => '#FEB58C',
					'alter_hover'      => '#F0A377',
					'alter_link2'      => '#ED6954',
					'alter_hover2'     => '#DA533E',
					'alter_link3'      => '#ADB5F4',
					'alter_hover3'     => '#99A2EE',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#F8F5EF',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#FEB58C',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E4DDD7',
					'input_bd_hover'   => '#DED6CE',
					'input_text'       => '#B8B8B8',
					'input_light'      => '#B8B8B8',
					'input_dark'       => '#1C1B1B',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#DBD4D4',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1C1B1B',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'extra_dark'
			'extra_dark'    => array(
				'title'    => esc_html__( 'Extra Dark', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#222322',
					'bd_color'         => '#373837',

					// Text and links colors
					'text'             => '#D6D6D6',
					'text_light'       => '#A2A4A2',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#FEB58C',
					'text_hover'       => '#F0A377',
					'text_link2'       => '#ED6954',
					'text_hover2'      => '#DA533E',
					'text_link3'       => '#ADB5F4',
					'text_hover3'      => '#99A2EE',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1A1B19',
					'alter_bg_hover'   => '#383D4B',
					'alter_bd_color'   => '#373837',
					'alter_bd_hover'   => '#373837',
					'alter_text'       => '#D6D6D6',
					'alter_light'      => '#A2A4A2',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#FEB58C',
					'alter_hover'      => '#F0A377',
					'alter_link2'      => '#ED6954',
					'alter_hover2'     => '#DA533E',
					'alter_link3'      => '#ADB5F4',
					'alter_hover3'     => '#99A2EE',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#F8F5EF',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#FEB58C',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#373837',
					'input_bd_hover'   => '#454545',
					'input_text'       => '#DBD4D4',
					'input_light'      => '#D6D6D6',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1C1B1B',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#1C1B1B',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'extra_dark_light'
			'extra_dark_light'    => array(
				'title'    => esc_html__( 'Extra Dark Light', 'resurs' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#1A1B19',
					'bd_color'         => '#373837',

					// Text and links colors
					'text'             => '#D6D6D6',
					'text_light'       => '#A2A4A2',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#FEB58C',
					'text_hover'       => '#F0A377',
					'text_link2'       => '#ED6954',
					'text_hover2'      => '#DA533E',
					'text_link3'       => '#ADB5F4',
					'text_hover3'      => '#99A2EE',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#222322',
					'alter_bg_hover'   => '#383D4B',
					'alter_bd_color'   => '#373837',
					'alter_bd_hover'   => '#373837',
					'alter_text'       => '#D6D6D6',
					'alter_light'      => '#A2A4A2',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#FEB58C',
					'alter_hover'      => '#F0A377',
					'alter_link2'      => '#ED6954',
					'alter_hover2'     => '#DA533E',
					'alter_link3'      => '#ADB5F4',
					'alter_hover3'     => '#99A2EE',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#272727',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373837',
					'extra_bd_hover'   => '#F8F5EF',
					'extra_text'       => '#D6D6D6',
					'extra_light'      => '#A2A4A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#FEB58C',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#373837',
					'input_bd_hover'   => '#454545',
					'input_text'       => '#DBD4D4',
					'input_light'      => '#D6D6D6',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1C1B1B',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#1C1B1B',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
		);
		resurs_storage_set( 'schemes', $schemes );
		resurs_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> resurs_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'resurs' ),
		//---> 	'description' => __( 'Description of the new color 1', 'resurs' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		resurs_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_08' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.8,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_dark_015'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.15,
				),
				'alter_dark_02'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.2,
				),
				'alter_dark_05'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.5,
				),
				'alter_dark_08'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.8,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_003'      => array(
					'color' => 'text_dark',
					'alpha' => 0.03,
				),
				'text_dark_005'      => array(
					'color' => 'text_dark',
					'alpha' => 0.05,
				),
				'text_dark_008'      => array(
					'color' => 'text_dark',
					'alpha' => 0.08,
				),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
				'text_dark_03'      => array(
					'color' => 'text_dark',
					'alpha' => 0.3,
				),
				'text_dark_05'      => array(
					'color' => 'text_dark',
					'alpha' => 0.5,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_dark_08'      => array(
					'color' => 'text_dark',
					'alpha' => 0.8,
				),
				'text_link_007'      => array(
					'color' => 'text_link',
					'alpha' => 0.07,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_03'      => array(
					'color' => 'text_link',
					'alpha' => 0.3,
				),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
					'color' => 'text_link2',
					'alpha' => 0.8,
				),
				'text_link2_007'      => array(
					'color' => 'text_link2',
					'alpha' => 0.07,
				),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
				'text_link2_03'      => array(
					'color' => 'text_link2',
					'alpha' => 0.3,
				),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
				'text_link3_007'      => array(
					'color' => 'text_link3',
					'alpha' => 0.07,
				),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
				'text_link3_03'      => array(
					'color' => 'text_link3',
					'alpha' => 0.3,
				),
				'inverse_text_03'      => array(
					'color' => 'inverse_text',
					'alpha' => 0.3,
				),
				'inverse_link_08'      => array(
					'color' => 'inverse_link',
					'alpha' => 0.8,
				),
				'inverse_hover_08'      => array(
					'color' => 'inverse_hover',
					'alpha' => 0.8,
				),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		resurs_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		resurs_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		resurs_storage_set(
			'color_presets', array(
				'autumn' => array(
					'title'  => esc_html__( 'Autumn', 'resurs' ),
					'colors' => array(
						'default' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
						),
						'dark' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
						)
					)
				),
				'green' => array(
					'title'  => esc_html__( 'Natural Green', 'resurs' ),
					'colors' => array(
						'default' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						),
						'dark' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						)
					)
				),
			)
		);
	}
}


// Background selection option
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'resurs_clone_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'resurs_clone_skin_theme_setup3', 3 );
	function resurs_clone_skin_theme_setup3() {
		resurs_storage_set_array_after( 'options', 'remove_margins', array(
				'extra_bg_image' => array(
					"title" => esc_html__('Extra background image', 'resurs'),
					"desc" => wp_kses_data( __('Select or upload background-image to display it in the page. Does not work for boxed body style.', 'resurs') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'resurs')
					),
					'dependency' => array(
						'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
					),
					"std" => '',
					'pro_only'   => RESURS_THEME_FREE,
					"type" => "image"
				),
				'extra_bg_image_size' => array(
					"title" => esc_html__('Extra background image size', 'resurs'),
					"desc" => wp_kses_data( __('Use size contain (cover original).', 'resurs') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'resurs')
					),
					'dependency' => array(
						'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
					),
					"std" => 0,
					'pro_only'   => RESURS_THEME_FREE,
					"type" => "switch"
				),
				'extra_bg_image_fixed' => array(
					'title' => esc_html__('Extra background attachment', 'resurs'),
					'desc' => wp_kses_data( __('Enable fixed position of the background image', 'resurs') ),
					'std' => 0,
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'resurs')
					),
					'dependency' => array(
						'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
					),
					'pro_only'   => RESURS_THEME_FREE,
					'type' => 'switch'
				),
			)
		);
	}
}

// Add div with background
if ( ! function_exists( 'resurs_skin_filter_page_wrap_class' ) ) {
	add_action('resurs_filter_page_wrap_class', 'resurs_skin_filter_page_wrap_class');
	function resurs_skin_filter_page_wrap_class($class) {
		$extra_bg_image = resurs_get_theme_option('extra_bg_image');
		$extra_bg_image_size = resurs_is_on(resurs_get_theme_option('extra_bg_image_size'));
		$extra_bg_image_fixed = resurs_is_on(resurs_get_theme_option('extra_bg_image_fixed'));
		$body_boxed_style = resurs_get_theme_option( 'body_style' ) == 'boxed';
		if (!empty( $extra_bg_image ) && !$body_boxed_style && !$extra_bg_image_fixed) {
			$custom_bg = ' ' . 'with_bg' .($extra_bg_image_size ? ' contain_size ' : ''). ' ' . resurs_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
			$class = $class . $custom_bg;
		} else if (!empty( $extra_bg_image ) && !$body_boxed_style && $extra_bg_image_fixed) {
			$class = $class . ' with_bg_fixed';
		}
		return $class;
	}
}
// Add div with fixed background
if ( ! function_exists( 'resurs_skin_custom_bg_layout' ) ) {
	add_action('resurs_action_page_wrap_start', 'resurs_skin_custom_bg_layout');
	function resurs_skin_custom_bg_layout() {
		$extra_bg_image = resurs_get_theme_option('extra_bg_image');
		$extra_bg_image_size = resurs_is_on(resurs_get_theme_option('extra_bg_image_size'));
		$extra_bg_image_fixed = resurs_is_on(resurs_get_theme_option('extra_bg_image_fixed'));
		$body_boxed_style = resurs_get_theme_option( 'body_style' ) == 'boxed';
		if (!empty( $extra_bg_image ) && !$body_boxed_style && $extra_bg_image_fixed) {
		$custom_bg = ($extra_bg_image_size ? ' contain_size ' : ''). ' ' . resurs_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
			?>
				<div class="custom_bg_fixed <?php echo esc_attr($custom_bg); ?>"></div>
			<?php
		}
    }
}

//Enqueue skin-specific scripts
if ( ! function_exists( 'resurs_skin_upgrade_style' ) ) {
	add_action( 'wp_enqueue_scripts', 'resurs_skin_upgrade_style', 2060 );
	function resurs_skin_upgrade_style() {
		$resurs_url = resurs_get_file_url( resurs_skins_get_current_skin_dir() . 'skin-upgrade-style.css' );	
		if ( '' != $resurs_url ) {
			wp_enqueue_style( 'resurs-skin-upgrade-style' . esc_attr( resurs_skins_get_current_skin_name() ), $resurs_url, array(), null );
		}
	}
}

// Activation methods
if ( ! function_exists( 'resurs_skin_filter_activation_methods2' ) ) {
	add_filter( 'trx_addons_filter_activation_methods', 'resurs_skin_filter_activation_methods2', 11, 1 );
	function resurs_skin_filter_activation_methods2( $args ) {
		$args['elements_key'] = true;
		return $args;
	}
}