<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_template_args = get_query_var( 'resurs_template_args' );

if ( is_array( $resurs_template_args ) ) {
	$resurs_columns    = empty( $resurs_template_args['columns'] ) ? 2 : max( 1, $resurs_template_args['columns'] );
	$resurs_blog_style = array( $resurs_template_args['type'], $resurs_columns );
    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns, ! empty( $resurs_template_args['columns_tablet']) ? $resurs_template_args['columns_tablet'] : '', ! empty($resurs_template_args['columns_mobile']) ? $resurs_template_args['columns_mobile'] : '' );
} else {
	$resurs_template_args = array();
	$resurs_blog_style = explode( '_', resurs_get_theme_option( 'blog_style' ) );
	$resurs_columns    = empty( $resurs_blog_style[1] ) ? 2 : max( 1, $resurs_blog_style[1] );
    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns );
}
$resurs_expanded   = ! resurs_sidebar_present() && resurs_get_theme_option( 'expand_content' ) == 'expand';

$resurs_post_format = get_post_format();
$resurs_post_format = empty( $resurs_post_format ) ? 'standard' : str_replace( 'post-format-', '', $resurs_post_format );

?><div class="<?php
	if ( ! empty( $resurs_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( resurs_is_blog_style_use_masonry( $resurs_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $resurs_columns ) : esc_attr( $resurs_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $resurs_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $resurs_columns )
				. ' post_layout_' . esc_attr( $resurs_blog_style[0] )
				. ' post_layout_' . esc_attr( $resurs_blog_style[0] ) . '_' . esc_attr( $resurs_columns )
	);
	resurs_add_blog_animation( $resurs_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$resurs_hover      = ! empty( $resurs_template_args['hover'] ) && ! resurs_is_inherit( $resurs_template_args['hover'] )
							? $resurs_template_args['hover']
							: resurs_get_theme_option( 'image_hover' );

	$resurs_components = ! empty( $resurs_template_args['meta_parts'] )
							? ( is_array( $resurs_template_args['meta_parts'] )
								? $resurs_template_args['meta_parts']
								: explode( ',', $resurs_template_args['meta_parts'] )
								)
							: resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) );

	resurs_show_post_featured( apply_filters( 'resurs_filter_args_featured',
		array(
			'thumb_size' => ! empty( $resurs_template_args['thumb_size'] )
				? $resurs_template_args['thumb_size']
				: resurs_get_thumb_size(
					'classic' == $resurs_blog_style[0]
						? ( strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $resurs_columns > 2 ? 'big' : 'huge' )
								: ( $resurs_columns > 2
									? ( $resurs_expanded ? 'square' : 'square' )
									: ($resurs_columns > 1 ? 'square' : ( $resurs_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $resurs_columns > 2 ? 'masonry-big' : 'full' )
								: ($resurs_columns === 1 ? ( $resurs_expanded ? 'huge' : 'big' ) : ( $resurs_columns <= 2 && $resurs_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $resurs_hover,
			'meta_parts' => $resurs_components,
			'no_links'   => ! empty( $resurs_template_args['no_links'] ),
        ),
        'content-classic',
        $resurs_template_args
    ) );

	// Title and post meta
	$resurs_show_title = get_the_title() != '';
	$resurs_show_meta  = count( $resurs_components ) > 0 && ! in_array( $resurs_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $resurs_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'resurs_filter_show_blog_meta', $resurs_show_meta, $resurs_components, 'classic' ) ) {
				if ( count( $resurs_components ) > 0 ) {
					do_action( 'resurs_action_before_post_meta' );
					resurs_show_post_meta(
						apply_filters(
							'resurs_filter_post_meta_args', array(
							'components' => join( ',', $resurs_components ),
							'seo'        => false,
							'echo'       => true,
						), $resurs_blog_style[0], $resurs_columns
						)
					);
					do_action( 'resurs_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'resurs_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'resurs_action_before_post_title' );
				if ( empty( $resurs_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'resurs_action_after_post_title' );
			}

			if( !in_array( $resurs_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'resurs_filter_show_blog_readmore', ! $resurs_show_title || ! empty( $resurs_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $resurs_template_args['no_links'] ) ) {
						do_action( 'resurs_action_before_post_readmore' );
						resurs_show_post_more_link( $resurs_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'resurs_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $resurs_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('resurs_filter_show_blog_excerpt', empty($resurs_template_args['hide_excerpt']) && resurs_get_theme_option('excerpt_length') > 0, 'classic')) {
			resurs_show_post_content($resurs_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $resurs_template_args['more_button'] )) {
			if ( empty( $resurs_template_args['no_links'] ) ) {
				do_action( 'resurs_action_before_post_readmore' );
				resurs_show_post_more_link( $resurs_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'resurs_action_after_post_readmore' );
			}
		}
		$resurs_content = ob_get_contents();
		ob_end_clean();
		resurs_show_layout($resurs_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
