<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RESURS
 * @since RESURS 1.0.50
 */

$resurs_template_args = get_query_var( 'resurs_template_args' );
if ( is_array( $resurs_template_args ) ) {
	$resurs_columns    = empty( $resurs_template_args['columns'] ) ? 2 : max( 1, $resurs_template_args['columns'] );
	$resurs_blog_style = array( $resurs_template_args['type'], $resurs_columns );
} else {
	$resurs_template_args = array();
	$resurs_blog_style = explode( '_', resurs_get_theme_option( 'blog_style' ) );
	$resurs_columns    = empty( $resurs_blog_style[1] ) ? 2 : max( 1, $resurs_blog_style[1] );
}
$resurs_blog_id       = resurs_get_custom_blog_id( join( '_', $resurs_blog_style ) );
$resurs_blog_style[0] = str_replace( 'blog-custom-', '', $resurs_blog_style[0] );
$resurs_expanded      = ! resurs_sidebar_present() && resurs_get_theme_option( 'expand_content' ) == 'expand';
$resurs_components    = ! empty( $resurs_template_args['meta_parts'] )
							? ( is_array( $resurs_template_args['meta_parts'] )
								? join( ',', $resurs_template_args['meta_parts'] )
								: $resurs_template_args['meta_parts']
								)
							: resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) );
$resurs_post_format   = get_post_format();
$resurs_post_format   = empty( $resurs_post_format ) ? 'standard' : str_replace( 'post-format-', '', $resurs_post_format );

$resurs_blog_meta     = resurs_get_custom_layout_meta( $resurs_blog_id );
$resurs_custom_style  = ! empty( $resurs_blog_meta['scripts_required'] ) ? $resurs_blog_meta['scripts_required'] : 'none';

if ( ! empty( $resurs_template_args['slider'] ) || $resurs_columns > 1 || ! resurs_is_off( $resurs_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $resurs_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( resurs_is_off( $resurs_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $resurs_custom_style ) ) . "-1_{$resurs_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $resurs_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $resurs_columns )
					. ' post_layout_' . esc_attr( $resurs_blog_style[0] )
					. ' post_layout_' . esc_attr( $resurs_blog_style[0] ) . '_' . esc_attr( $resurs_columns )
					. ( ! resurs_is_off( $resurs_custom_style )
						? ' post_layout_' . esc_attr( $resurs_custom_style )
							. ' post_layout_' . esc_attr( $resurs_custom_style ) . '_' . esc_attr( $resurs_columns )
						: ''
						)
		);
	resurs_add_blog_animation( $resurs_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'resurs_action_show_layout', $resurs_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $resurs_template_args['slider'] ) || $resurs_columns > 1 || ! resurs_is_off( $resurs_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
