<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_template_args = get_query_var( 'resurs_template_args' );
if ( is_array( $resurs_template_args ) ) {
	$resurs_columns    = empty( $resurs_template_args['columns'] ) ? 2 : max( 1, $resurs_template_args['columns'] );
	$resurs_blog_style = array( $resurs_template_args['type'], $resurs_columns );
    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns, ! empty( $resurs_template_args['columns_tablet']) ? $resurs_template_args['columns_tablet'] : '', ! empty($resurs_template_args['columns_mobile']) ? $resurs_template_args['columns_mobile'] : '' );
} else {
	$resurs_template_args = array();
	$resurs_blog_style = explode( '_', resurs_get_theme_option( 'blog_style' ) );
	$resurs_columns    = empty( $resurs_blog_style[1] ) ? 2 : max( 1, $resurs_blog_style[1] );
    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns );
}

$resurs_post_format = get_post_format();
$resurs_post_format = empty( $resurs_post_format ) ? 'standard' : str_replace( 'post-format-', '', $resurs_post_format );

?><div class="
<?php
if ( ! empty( $resurs_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( resurs_is_blog_style_use_masonry( $resurs_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $resurs_columns ) : esc_attr( $resurs_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $resurs_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $resurs_columns )
		. ( 'portfolio' != $resurs_blog_style[0] ? ' ' . esc_attr( $resurs_blog_style[0] )  . '_' . esc_attr( $resurs_columns ) : '' )
	);
	resurs_add_blog_animation( $resurs_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$resurs_hover   = ! empty( $resurs_template_args['hover'] ) && ! resurs_is_inherit( $resurs_template_args['hover'] )
								? $resurs_template_args['hover']
								: resurs_get_theme_option( 'image_hover' );

	if ( 'dots' == $resurs_hover ) {
		$resurs_post_link = empty( $resurs_template_args['no_links'] )
								? ( ! empty( $resurs_template_args['link'] )
									? $resurs_template_args['link']
									: get_permalink()
									)
								: '';
		$resurs_target    = ! empty( $resurs_post_link ) && resurs_is_external_url( $resurs_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$resurs_components = ! empty( $resurs_template_args['meta_parts'] )
							? ( is_array( $resurs_template_args['meta_parts'] )
								? $resurs_template_args['meta_parts']
								: explode( ',', $resurs_template_args['meta_parts'] )
								)
							: resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) );

	// Featured image
	resurs_show_post_featured( apply_filters( 'resurs_filter_args_featured',
        array(
			'hover'         => $resurs_hover,
			'no_links'      => ! empty( $resurs_template_args['no_links'] ),
			'thumb_size'    => ! empty( $resurs_template_args['thumb_size'] )
								? $resurs_template_args['thumb_size']
								: resurs_get_thumb_size(
									resurs_is_blog_style_use_masonry( $resurs_blog_style[0] )
										? (	strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false || $resurs_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false || $resurs_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => resurs_is_blog_style_use_masonry( $resurs_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $resurs_components,
			'class'         => 'dots' == $resurs_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $resurs_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $resurs_post_link )
												? '<a href="' . esc_url( $resurs_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $resurs_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $resurs_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $resurs_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!