<?php
/**
 * The template to display default site footer
 *
 * @package RESURS
 * @since RESURS 1.0.10
 */

$resurs_footer_id = resurs_get_custom_footer_id();
$resurs_footer_meta = get_post_meta( $resurs_footer_id, 'trx_addons_options', true );
if ( ! empty( $resurs_footer_meta['margin'] ) ) {
	resurs_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( resurs_prepare_css_value( $resurs_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $resurs_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $resurs_footer_id ) ) ); ?>
						<?php
						$resurs_footer_scheme = resurs_get_theme_option( 'footer_scheme' );
						if ( ! empty( $resurs_footer_scheme ) && ! resurs_is_inherit( $resurs_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $resurs_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'resurs_action_show_layout', $resurs_footer_id );
	?>
</footer><!-- /.footer_wrap -->
