<?php
/**
 * The template to display the widgets area in the header
 *
 * @package RESURS
 * @since RESURS 1.0
 */

// Header sidebar
$resurs_header_name    = resurs_get_theme_option( 'header_widgets' );
$resurs_header_present = ! resurs_is_off( $resurs_header_name ) && is_active_sidebar( $resurs_header_name );
if ( $resurs_header_present ) {
	resurs_storage_set( 'current_sidebar', 'header' );
	$resurs_header_wide = resurs_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $resurs_header_name ) ) {
		dynamic_sidebar( $resurs_header_name );
	}
	$resurs_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $resurs_widgets_output ) ) {
		$resurs_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $resurs_widgets_output );
		$resurs_need_columns   = strpos( $resurs_widgets_output, 'columns_wrap' ) === false;
		if ( $resurs_need_columns ) {
			$resurs_columns = max( 0, (int) resurs_get_theme_option( 'header_columns' ) );
			if ( 0 == $resurs_columns ) {
				$resurs_columns = min( 6, max( 1, resurs_tags_count( $resurs_widgets_output, 'aside' ) ) );
			}
			if ( $resurs_columns > 1 ) {
				$resurs_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $resurs_columns ) . ' widget', $resurs_widgets_output );
			} else {
				$resurs_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $resurs_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'resurs_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $resurs_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $resurs_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'resurs_action_before_sidebar', 'header' );
				resurs_show_layout( $resurs_widgets_output );
				do_action( 'resurs_action_after_sidebar', 'header' );
				if ( $resurs_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $resurs_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'resurs_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
