<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package RESURS
 * @since RESURS 1.0
 */

							do_action( 'resurs_action_page_content_end_text' );
							
							// Widgets area below the content
							resurs_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'resurs_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'resurs_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'resurs_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'resurs_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$resurs_body_style = resurs_get_theme_option( 'body_style' );
					$resurs_widgets_name = resurs_get_theme_option( 'widgets_below_page', 'hide' );
					$resurs_show_widgets = ! resurs_is_off( $resurs_widgets_name ) && is_active_sidebar( $resurs_widgets_name );
					$resurs_show_related = resurs_is_single() && resurs_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $resurs_show_widgets || $resurs_show_related ) {
						if ( 'fullscreen' != $resurs_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $resurs_show_related ) {
							do_action( 'resurs_action_related_posts' );
						}

						// Widgets area below page content
						if ( $resurs_show_widgets ) {
							resurs_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $resurs_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'resurs_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'resurs_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! resurs_is_singular( 'post' ) && ! resurs_is_singular( 'attachment' ) ) || ! in_array ( resurs_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="resurs_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'resurs_action_before_footer' );

				// Footer
				$resurs_footer_type = resurs_get_theme_option( 'footer_type' );
				if ( 'custom' == $resurs_footer_type && ! resurs_is_layouts_available() ) {
					$resurs_footer_type = 'default';
				}
				get_template_part( apply_filters( 'resurs_filter_get_template_part', "templates/footer-" . sanitize_file_name( $resurs_footer_type ) ) );

				do_action( 'resurs_action_after_footer' );

			}
			?>

			<?php do_action( 'resurs_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'resurs_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'resurs_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>