<?php
/**
 * The Front Page template file.
 *
 * @package RESURS
 * @since RESURS 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( resurs_is_on( resurs_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$resurs_sections = resurs_array_get_keys_by_value( resurs_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $resurs_sections ) ) {
			foreach ( $resurs_sections as $resurs_section ) {
				get_template_part( apply_filters( 'resurs_filter_get_template_part', 'front-page/section', $resurs_section ), $resurs_section );
			}
		}

		// Else if this page is a blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'blog' ) );

		// Else - display a native page content
	} else {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'page' ) );
	}

	// Else get the template 'index.php' to show posts
} else {
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'index' ) );
}

get_footer();
