<div class="front_page_section front_page_section_blog<?php
	$resurs_scheme = resurs_get_theme_option( 'front_page_blog_scheme' );
	if ( ! empty( $resurs_scheme ) && ! resurs_is_inherit( $resurs_scheme ) ) {
		echo ' scheme_' . esc_attr( $resurs_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( resurs_get_theme_option( 'front_page_blog_paddings' ) );
	if ( resurs_get_theme_option( 'front_page_blog_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$resurs_css      = '';
		$resurs_bg_image = resurs_get_theme_option( 'front_page_blog_bg_image' );
		if ( ! empty( $resurs_bg_image ) ) {
			$resurs_css .= 'background-image: url(' . esc_url( resurs_get_attachment_url( $resurs_bg_image ) ) . ');';
		}
		if ( ! empty( $resurs_css ) ) {
			echo ' style="' . esc_attr( $resurs_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$resurs_anchor_icon = resurs_get_theme_option( 'front_page_blog_anchor_icon' );
	$resurs_anchor_text = resurs_get_theme_option( 'front_page_blog_anchor_text' );
if ( ( ! empty( $resurs_anchor_icon ) || ! empty( $resurs_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_blog"'
									. ( ! empty( $resurs_anchor_icon ) ? ' icon="' . esc_attr( $resurs_anchor_icon ) . '"' : '' )
									. ( ! empty( $resurs_anchor_text ) ? ' title="' . esc_attr( $resurs_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_blog_inner
	<?php
	if ( resurs_get_theme_option( 'front_page_blog_fullheight' ) ) {
		echo ' resurs-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$resurs_css      = '';
			$resurs_bg_mask  = resurs_get_theme_option( 'front_page_blog_bg_mask' );
			$resurs_bg_color_type = resurs_get_theme_option( 'front_page_blog_bg_color_type' );
			if ( 'custom' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_theme_option( 'front_page_blog_bg_color' );
			} elseif ( 'scheme_bg_color' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_scheme_color( 'bg_color', $resurs_scheme );
			} else {
				$resurs_bg_color = '';
			}
			if ( ! empty( $resurs_bg_color ) && $resurs_bg_mask > 0 ) {
				$resurs_css .= 'background-color: ' . esc_attr(
					1 == $resurs_bg_mask ? $resurs_bg_color : resurs_hex2rgba( $resurs_bg_color, $resurs_bg_mask )
				) . ';';
			}
			if ( ! empty( $resurs_css ) ) {
				echo ' style="' . esc_attr( $resurs_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_blog_content_wrap content_wrap">
			<?php
			// Caption
			$resurs_caption = resurs_get_theme_option( 'front_page_blog_caption' );
			if ( ! empty( $resurs_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_blog_caption front_page_block_<?php echo ! empty( $resurs_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $resurs_caption, 'resurs_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$resurs_description = resurs_get_theme_option( 'front_page_blog_description' );
			if ( ! empty( $resurs_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_blog_description front_page_block_<?php echo ! empty( $resurs_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $resurs_description ), 'resurs_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_blog_output">
				<?php
				if ( is_active_sidebar( 'front_page_blog_widgets' ) ) {
					dynamic_sidebar( 'front_page_blog_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! resurs_exists_trx_addons() ) {
						resurs_customizer_need_trx_addons_message();
					} else {
						resurs_customizer_need_widgets_message( 'front_page_blog_caption', 'ThemeREX Addons - Blogger' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
