<?php
$resurs_slider_sc = resurs_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $resurs_slider_sc ) && strpos( $resurs_slider_sc, '[' ) !== false && strpos( $resurs_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( resurs_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$resurs_anchor_icon = resurs_get_theme_option( 'front_page_title_anchor_icon' );
		$resurs_anchor_text = resurs_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $resurs_anchor_icon ) || ! empty( $resurs_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $resurs_anchor_icon ) ? ' icon="' . esc_attr( $resurs_anchor_icon ) . '"' : '' )
									. ( ! empty( $resurs_anchor_text ) ? ' title="' . esc_attr( $resurs_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $resurs_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$resurs_scheme = resurs_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $resurs_scheme ) && ! resurs_is_inherit( $resurs_scheme ) ) {
			echo ' scheme_' . esc_attr( $resurs_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( resurs_get_theme_option( 'front_page_title_paddings' ) );
		if ( resurs_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$resurs_css      = '';
		$resurs_bg_image = resurs_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $resurs_bg_image ) ) {
			$resurs_css .= 'background-image: url(' . esc_url( resurs_get_attachment_url( $resurs_bg_image ) ) . ');';
		}
		if ( ! empty( $resurs_css ) ) {
			echo ' style="' . esc_attr( $resurs_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$resurs_anchor_icon = resurs_get_theme_option( 'front_page_title_anchor_icon' );
		$resurs_anchor_text = resurs_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $resurs_anchor_icon ) || ! empty( $resurs_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $resurs_anchor_icon ) ? ' icon="' . esc_attr( $resurs_anchor_icon ) . '"' : '' )
									. ( ! empty( $resurs_anchor_text ) ? ' title="' . esc_attr( $resurs_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( resurs_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' resurs-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$resurs_css      = '';
			$resurs_bg_mask  = resurs_get_theme_option( 'front_page_title_bg_mask' );
			$resurs_bg_color_type = resurs_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $resurs_bg_color_type ) {
				$resurs_bg_color = resurs_get_scheme_color( 'bg_color', $resurs_scheme );
			} else {
				$resurs_bg_color = '';
			}
			if ( ! empty( $resurs_bg_color ) && $resurs_bg_mask > 0 ) {
				$resurs_css .= 'background-color: ' . esc_attr(
					1 == $resurs_bg_mask ? $resurs_bg_color : resurs_hex2rgba( $resurs_bg_color, $resurs_bg_mask )
				) . ';';
			}
			if ( ! empty( $resurs_css ) ) {
				echo ' style="' . esc_attr( $resurs_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$resurs_caption = resurs_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $resurs_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $resurs_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $resurs_caption, 'resurs_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$resurs_description = resurs_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $resurs_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $resurs_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $resurs_description ), 'resurs_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( resurs_get_theme_option( 'front_page_title_button1_link' ) != '' || resurs_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						resurs_show_layout( resurs_customizer_partial_refresh_front_page_title_button1_link() );
						resurs_show_layout( resurs_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
