<?php
/**
 * The Header: Logo and main menu
 *
 * @package RESURS
 * @since RESURS 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( resurs_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'resurs_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'resurs_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('resurs_action_body_wrap_attributes'); ?>>

		<?php do_action( 'resurs_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'resurs_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('resurs_action_page_wrap_attributes'); ?>>

			<?php do_action( 'resurs_action_page_wrap_start' ); ?>

			<?php
			$resurs_full_post_loading = ( resurs_is_singular( 'post' ) || resurs_is_singular( 'attachment' ) ) && resurs_get_value_gp( 'action' ) == 'full_post_loading';
			$resurs_prev_post_loading = ( resurs_is_singular( 'post' ) || resurs_is_singular( 'attachment' ) ) && resurs_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $resurs_full_post_loading && ! $resurs_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="resurs_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'resurs_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'resurs' ); ?></a>
				<?php if ( resurs_sidebar_present() ) { ?>
				<a class="resurs_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'resurs_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'resurs' ); ?></a>
				<?php } ?>
				<a class="resurs_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'resurs_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'resurs' ); ?></a>

				<?php
				do_action( 'resurs_action_before_header' );

				// Header
				$resurs_header_type = resurs_get_theme_option( 'header_type' );
				if ( 'custom' == $resurs_header_type && ! resurs_is_layouts_available() ) {
					$resurs_header_type = 'default';
				}
				get_template_part( apply_filters( 'resurs_filter_get_template_part', "templates/header-" . sanitize_file_name( $resurs_header_type ) ) );

				// Side menu
				if ( in_array( resurs_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'resurs_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'resurs_action_after_header' );

			}
			?>

			<?php do_action( 'resurs_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( resurs_is_off( resurs_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $resurs_header_type ) ) {
						$resurs_header_type = resurs_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $resurs_header_type && resurs_is_layouts_available() ) {
						$resurs_header_id = resurs_get_custom_header_id();
						if ( $resurs_header_id > 0 ) {
							$resurs_header_meta = resurs_get_custom_layout_meta( $resurs_header_id );
							if ( ! empty( $resurs_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$resurs_footer_type = resurs_get_theme_option( 'footer_type' );
					if ( 'custom' == $resurs_footer_type && resurs_is_layouts_available() ) {
						$resurs_footer_id = resurs_get_custom_footer_id();
						if ( $resurs_footer_id ) {
							$resurs_footer_meta = resurs_get_custom_layout_meta( $resurs_footer_id );
							if ( ! empty( $resurs_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'resurs_action_page_content_wrap_class', $resurs_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'resurs_filter_is_prev_post_loading', $resurs_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( resurs_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'resurs_action_page_content_wrap_data', $resurs_prev_post_loading );
			?>>
				<?php
				do_action( 'resurs_action_page_content_wrap', $resurs_full_post_loading || $resurs_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'resurs_filter_single_post_header', resurs_is_singular( 'post' ) || resurs_is_singular( 'attachment' ) ) ) {
					if ( $resurs_prev_post_loading ) {
						if ( resurs_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'resurs_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$resurs_path = apply_filters( 'resurs_filter_get_template_part', 'templates/single-styles/' . resurs_get_theme_option( 'single_style' ) );
					if ( resurs_get_file_dir( $resurs_path . '.php' ) != '' ) {
						get_template_part( $resurs_path );
					}
				}

				// Widgets area above page
				$resurs_body_style   = resurs_get_theme_option( 'body_style' );
				$resurs_widgets_name = resurs_get_theme_option( 'widgets_above_page', 'hide' );
				$resurs_show_widgets = ! resurs_is_off( $resurs_widgets_name ) && is_active_sidebar( $resurs_widgets_name );
				if ( $resurs_show_widgets ) {
					if ( 'fullscreen' != $resurs_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					resurs_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $resurs_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'resurs_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $resurs_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'resurs_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'resurs_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="resurs_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( resurs_is_singular( 'post' ) || resurs_is_singular( 'attachment' ) )
							&& $resurs_prev_post_loading 
							&& resurs_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'resurs_action_between_posts' );
						}

						// Widgets area above content
						resurs_create_widgets_area( 'widgets_above_content' );

						do_action( 'resurs_action_page_content_start_text' );
