<?php
/**
 * The template to display the attachment
 *
 * @package RESURS
 * @since RESURS 1.0
 */


get_header();

while ( have_posts() ) {
	the_post();

	// Display post's content
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/content', 'single-' . resurs_get_theme_option( 'single_style' ) ), 'single-' . resurs_get_theme_option( 'single_style' ) );

	// Parent post navigation.
	$resurs_posts_navigation = resurs_get_theme_option( 'posts_navigation' );
	if ( 'links' == $resurs_posts_navigation ) {
		?>
		<div class="nav-links-single<?php
			if ( ! resurs_is_off( resurs_get_theme_option( 'posts_navigation_fixed', 0 ) ) ) {
				echo ' nav-links-fixed fixed';
			}
		?>">
			<?php
			the_post_navigation( apply_filters( 'resurs_filter_post_navigation_args', array(
					'prev_text' => '<span class="nav-arrow"></span>'
						. '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Published in', 'resurs' ) . '</span> '
						. '<span class="screen-reader-text">' . esc_html__( 'Previous post:', 'resurs' ) . '</span> '
						. '<h5 class="post-title">%title</h5>'
						. '<span class="post_date">%date</span>',
			), 'image' ) );
			?>
		</div>
		<?php
	}

	// Comments
	do_action( 'resurs_action_before_comments' );
	comments_template();
	do_action( 'resurs_action_after_comments' );
}

get_footer();
