<?php
/**
 * The template to display single post
 *
 * @package RESURS
 * @since RESURS 1.0
 */

// Full post loading
$full_post_loading          = resurs_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = resurs_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = resurs_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$resurs_related_position   = resurs_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$resurs_posts_navigation   = resurs_get_theme_option( 'posts_navigation' );
$resurs_prev_post          = false;
$resurs_prev_post_same_cat = (int)resurs_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( resurs_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	resurs_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'resurs_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $resurs_posts_navigation ) {
		$resurs_prev_post = get_previous_post( $resurs_prev_post_same_cat );  // Get post from same category
		if ( ! $resurs_prev_post && $resurs_prev_post_same_cat ) {
			$resurs_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $resurs_prev_post ) {
			$resurs_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $resurs_prev_post ) ) {
		resurs_sc_layouts_showed( 'featured', false );
		resurs_sc_layouts_showed( 'title', false );
		resurs_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $resurs_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/content', 'single-' . resurs_get_theme_option( 'single_style' ) ), 'single-' . resurs_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $resurs_related_position, 'inside' ) === 0 ) {
		$resurs_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'resurs_action_related_posts' );
		$resurs_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $resurs_related_content ) ) {
			$resurs_related_position_inside = max( 0, min( 9, resurs_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $resurs_related_position_inside ) {
				$resurs_related_position_inside = mt_rand( 1, 9 );
			}

			$resurs_p_number         = 0;
			$resurs_related_inserted = false;
			$resurs_in_block         = false;
			$resurs_content_start    = strpos( $resurs_content, '<div class="post_content' );
			$resurs_content_end      = strrpos( $resurs_content, '</div>' );

			for ( $i = max( 0, $resurs_content_start ); $i < min( strlen( $resurs_content ) - 3, $resurs_content_end ); $i++ ) {
				if ( $resurs_content[ $i ] != '<' ) {
					continue;
				}
				if ( $resurs_in_block ) {
					if ( strtolower( substr( $resurs_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$resurs_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $resurs_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $resurs_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$resurs_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $resurs_content[ $i + 1 ] && in_array( $resurs_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$resurs_p_number++;
					if ( $resurs_related_position_inside == $resurs_p_number ) {
						$resurs_related_inserted = true;
						$resurs_content = ( $i > 0 ? substr( $resurs_content, 0, $i ) : '' )
											. $resurs_related_content
											. substr( $resurs_content, $i );
					}
				}
			}
			if ( ! $resurs_related_inserted ) {
				if ( $resurs_content_end > 0 ) {
					$resurs_content = substr( $resurs_content, 0, $resurs_content_end ) . $resurs_related_content . substr( $resurs_content, $resurs_content_end );
				} else {
					$resurs_content .= $resurs_related_content;
				}
			}
		}

		resurs_show_layout( $resurs_content );
	}

	// Comments
	do_action( 'resurs_action_before_comments' );
	comments_template();
	do_action( 'resurs_action_after_comments' );

	// Related posts
	if ( 'below_content' == $resurs_related_position
		&& ( 'scroll' != $resurs_posts_navigation || (int)resurs_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)resurs_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'resurs_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $resurs_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $resurs_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $resurs_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $resurs_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'resurs_action_nav_links_single_scroll_data', $resurs_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
