<?php
/**
 * The template to display Admin notices
 *
 * @package RESURS
 * @since RESURS 1.0.1
 */

$resurs_theme_slug = get_option( 'template' );
$resurs_theme_obj  = wp_get_theme( $resurs_theme_slug );
?>
<div class="resurs_admin_notice resurs_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$resurs_theme_img = resurs_get_file_url( 'screenshot.jpg' );
	if ( '' != $resurs_theme_img ) {
		?>
		<div class="resurs_notice_image"><img src="<?php echo esc_url( $resurs_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'resurs' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="resurs_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'resurs' ),
				$resurs_theme_obj->get( 'Name' ) . ( RESURS_THEME_FREE ? ' ' . __( 'Free', 'resurs' ) : '' ),
				$resurs_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="resurs_notice_text">
		<p class="resurs_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $resurs_theme_obj->description ) );
			?>
		</p>
		<p class="resurs_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'resurs' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="resurs_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=resurs_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'resurs' );
			?>
		</a>
	</div>
</div>
