<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RESURS
 * @since RESURS 1.71.0
 */

$resurs_template_args = get_query_var( 'resurs_template_args' );
if ( ! is_array( $resurs_template_args ) ) {
	$resurs_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$resurs_columns       = 1;

$resurs_expanded      = ! resurs_sidebar_present() && resurs_get_theme_option( 'expand_content' ) == 'expand';

$resurs_post_format   = get_post_format();
$resurs_post_format   = empty( $resurs_post_format ) ? 'standard' : str_replace( 'post-format-', '', $resurs_post_format );

if ( is_array( $resurs_template_args ) ) {
	$resurs_columns    = empty( $resurs_template_args['columns'] ) ? 1 : max( 1, $resurs_template_args['columns'] );
	$resurs_blog_style = array( $resurs_template_args['type'], $resurs_columns );
	if ( ! empty( $resurs_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $resurs_columns > 1 ) {
	    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns, ! empty( $resurs_template_args['columns_tablet']) ? $resurs_template_args['columns_tablet'] : '', ! empty($resurs_template_args['columns_mobile']) ? $resurs_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $resurs_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $resurs_post_format ) );
	resurs_add_blog_animation( $resurs_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$resurs_hover      = ! empty( $resurs_template_args['hover'] ) && ! resurs_is_inherit( $resurs_template_args['hover'] )
							? $resurs_template_args['hover']
							: resurs_get_theme_option( 'image_hover' );
	$resurs_components = ! empty( $resurs_template_args['meta_parts'] )
							? ( is_array( $resurs_template_args['meta_parts'] )
								? $resurs_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $resurs_template_args['meta_parts'] ) )
								)
							: resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) );
	resurs_show_post_featured( apply_filters( 'resurs_filter_args_featured',
		array(
			'no_links'   => ! empty( $resurs_template_args['no_links'] ),
			'hover'      => $resurs_hover,
			'meta_parts' => $resurs_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $resurs_template_args['thumb_size'] )
								? $resurs_template_args['thumb_size']
								: resurs_get_thumb_size( 
								in_array( $resurs_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $resurs_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$resurs_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$resurs_show_title = get_the_title() != '';
		$resurs_show_meta  = count( $resurs_components ) > 0 && ! in_array( $resurs_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $resurs_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'resurs_filter_show_blog_categories', $resurs_show_meta && in_array( 'categories', $resurs_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'resurs_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						resurs_show_post_meta( apply_filters(
															'resurs_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $resurs_hover, 1
															)
											);
						?>
					</div>
					<?php
					$resurs_components = resurs_array_delete_by_value( $resurs_components, 'categories' );
					do_action( 'resurs_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'resurs_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'resurs_action_before_post_title' );
					if ( empty( $resurs_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'resurs_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $resurs_template_args['excerpt_length'] ) && ! in_array( $resurs_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$resurs_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'resurs_filter_show_blog_excerpt', empty( $resurs_template_args['hide_excerpt'] ) && resurs_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				resurs_show_post_content( $resurs_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'resurs_filter_show_blog_meta', $resurs_show_meta, $resurs_components, 'band' ) ) {
			if ( count( $resurs_components ) > 0 ) {
				do_action( 'resurs_action_before_post_meta' );
				resurs_show_post_meta(
					apply_filters(
						'resurs_filter_post_meta_args', array(
							'components' => join( ',', $resurs_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'resurs_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'resurs_filter_show_blog_readmore', ! $resurs_show_title || ! empty( $resurs_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $resurs_template_args['no_links'] ) ) {
				do_action( 'resurs_action_before_post_readmore' );
				resurs_show_post_more_link( $resurs_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'resurs_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $resurs_template_args ) ) {
	if ( ! empty( $resurs_template_args['slider'] ) || $resurs_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
