<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_template_args = get_query_var( 'resurs_template_args' );
$resurs_columns = 1;
if ( is_array( $resurs_template_args ) ) {
	$resurs_columns    = empty( $resurs_template_args['columns'] ) ? 1 : max( 1, $resurs_template_args['columns'] );
	$resurs_blog_style = array( $resurs_template_args['type'], $resurs_columns );
	if ( ! empty( $resurs_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $resurs_columns > 1 ) {
	    $resurs_columns_class = resurs_get_column_class( 1, $resurs_columns, ! empty( $resurs_template_args['columns_tablet']) ? $resurs_template_args['columns_tablet'] : '', ! empty($resurs_template_args['columns_mobile']) ? $resurs_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $resurs_columns_class ); ?>">
		<?php
	}
} else {
	$resurs_template_args = array();
}
$resurs_expanded    = ! resurs_sidebar_present() && resurs_get_theme_option( 'expand_content' ) == 'expand';
$resurs_post_format = get_post_format();
$resurs_post_format = empty( $resurs_post_format ) ? 'standard' : str_replace( 'post-format-', '', $resurs_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $resurs_post_format ) );
	resurs_add_blog_animation( $resurs_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$resurs_hover      = ! empty( $resurs_template_args['hover'] ) && ! resurs_is_inherit( $resurs_template_args['hover'] )
							? $resurs_template_args['hover']
							: resurs_get_theme_option( 'image_hover' );
	$resurs_components = ! empty( $resurs_template_args['meta_parts'] )
							? ( is_array( $resurs_template_args['meta_parts'] )
								? $resurs_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $resurs_template_args['meta_parts'] ) )
								)
							: resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) );
	resurs_show_post_featured( apply_filters( 'resurs_filter_args_featured',
		array(
			'no_links'   => ! empty( $resurs_template_args['no_links'] ),
			'hover'      => $resurs_hover,
			'meta_parts' => $resurs_components,
			'thumb_size' => ! empty( $resurs_template_args['thumb_size'] )
							? $resurs_template_args['thumb_size']
							: resurs_get_thumb_size( strpos( resurs_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $resurs_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$resurs_template_args
	) );

	// Title and post meta
	$resurs_show_title = get_the_title() != '';
	$resurs_show_meta  = count( $resurs_components ) > 0 && ! in_array( $resurs_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $resurs_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'resurs_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'resurs_action_before_post_title' );
				if ( empty( $resurs_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'resurs_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'resurs_filter_show_blog_excerpt', empty( $resurs_template_args['hide_excerpt'] ) && resurs_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'resurs_filter_show_blog_meta', $resurs_show_meta, $resurs_components, 'excerpt' ) ) {
				if ( count( $resurs_components ) > 0 ) {
					do_action( 'resurs_action_before_post_meta' );
					resurs_show_post_meta(
						apply_filters(
							'resurs_filter_post_meta_args', array(
								'components' => join( ',', $resurs_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'resurs_action_after_post_meta' );
				}
			}

			if ( resurs_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'resurs_action_before_full_post_content' );
					the_content( '' );
					do_action( 'resurs_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'resurs' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'resurs' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				resurs_show_post_content( $resurs_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'resurs_filter_show_blog_readmore',  ! isset( $resurs_template_args['more_button'] ) || ! empty( $resurs_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $resurs_template_args['no_links'] ) ) {
					do_action( 'resurs_action_before_post_readmore' );
					if ( resurs_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						resurs_show_post_more_link( $resurs_template_args, '<p>', '</p>' );
					} else {
						resurs_show_post_comments_link( $resurs_template_args, '<p>', '</p>' );
					}
					do_action( 'resurs_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $resurs_template_args ) ) {
	if ( ! empty( $resurs_template_args['slider'] ) || $resurs_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
