<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package RESURS
 * @since RESURS 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$resurs_copyright_scheme = resurs_get_theme_option( 'copyright_scheme' );
if ( ! empty( $resurs_copyright_scheme ) && ! resurs_is_inherit( $resurs_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $resurs_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$resurs_copyright = resurs_get_theme_option( 'copyright' );
			if ( ! empty( $resurs_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$resurs_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $resurs_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$resurs_copyright = resurs_prepare_macros( $resurs_copyright );
				// Display copyright
				echo wp_kses( nl2br( $resurs_copyright ), 'resurs_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
