<?php
/**
 * The template to display the site logo in the footer
 *
 * @package RESURS
 * @since RESURS 1.0.10
 */

// Logo
if ( resurs_is_on( resurs_get_theme_option( 'logo_in_footer' ) ) ) {
	$resurs_logo_image = resurs_get_logo_image( 'footer' );
	$resurs_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $resurs_logo_image['logo'] ) || ! empty( $resurs_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $resurs_logo_image['logo'] ) ) {
					$resurs_attr = resurs_getimagesize( $resurs_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $resurs_logo_image['logo'] ) . '"'
								. ( ! empty( $resurs_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $resurs_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'resurs' ) . '"'
								. ( ! empty( $resurs_attr[3] ) ? ' ' . wp_kses_data( $resurs_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $resurs_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $resurs_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
