<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package RESURS
 * @since RESURS 1.0.10
 */

// Footer sidebar
$resurs_footer_name    = resurs_get_theme_option( 'footer_widgets' );
$resurs_footer_present = ! resurs_is_off( $resurs_footer_name ) && is_active_sidebar( $resurs_footer_name );
if ( $resurs_footer_present ) {
	resurs_storage_set( 'current_sidebar', 'footer' );
	$resurs_footer_wide = resurs_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $resurs_footer_name ) ) {
		dynamic_sidebar( $resurs_footer_name );
	}
	$resurs_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $resurs_out ) ) {
		$resurs_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $resurs_out );
		$resurs_need_columns = true;   //or check: strpos($resurs_out, 'columns_wrap')===false;
		if ( $resurs_need_columns ) {
			$resurs_columns = max( 0, (int) resurs_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $resurs_columns ) {
				$resurs_columns = min( 4, max( 1, resurs_tags_count( $resurs_out, 'aside' ) ) );
			}
			if ( $resurs_columns > 1 ) {
				$resurs_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $resurs_columns ) . ' widget', $resurs_out );
			} else {
				$resurs_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $resurs_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'resurs_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $resurs_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $resurs_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'resurs_action_before_sidebar', 'footer' );
				resurs_show_layout( $resurs_out );
				do_action( 'resurs_action_after_sidebar', 'footer' );
				if ( $resurs_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $resurs_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'resurs_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
