<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package RESURS
 * @since RESURS 1.0.06
 */

$resurs_header_css   = '';
$resurs_header_image = get_header_image();
$resurs_header_video = resurs_get_header_video();
if ( ! empty( $resurs_header_image ) && resurs_trx_addons_featured_image_override( is_singular() || resurs_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$resurs_header_image = resurs_get_current_mode_image( $resurs_header_image );
}

$resurs_header_id = resurs_get_custom_header_id();
$resurs_header_meta = get_post_meta( $resurs_header_id, 'trx_addons_options', true );
if ( ! empty( $resurs_header_meta['margin'] ) ) {
	resurs_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( resurs_prepare_css_value( $resurs_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $resurs_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $resurs_header_id ) ) ); ?>
				<?php
				echo ! empty( $resurs_header_image ) || ! empty( $resurs_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $resurs_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $resurs_header_image ) {
					echo ' ' . esc_attr( resurs_add_inline_css_class( 'background-image: url(' . esc_url( $resurs_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( resurs_is_on( resurs_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight resurs-full-height';
				}
				$resurs_header_scheme = resurs_get_theme_option( 'header_scheme' );
				if ( ! empty( $resurs_header_scheme ) && ! resurs_is_inherit( $resurs_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $resurs_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $resurs_header_video ) ) {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'resurs_action_show_layout', $resurs_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
