<?php
/**
 * The template to display default site header
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_header_css   = '';
$resurs_header_image = get_header_image();
$resurs_header_video = resurs_get_header_video();
if ( ! empty( $resurs_header_image ) && resurs_trx_addons_featured_image_override( is_singular() || resurs_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$resurs_header_image = resurs_get_current_mode_image( $resurs_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $resurs_header_image ) || ! empty( $resurs_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $resurs_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $resurs_header_image ) {
		echo ' ' . esc_attr( resurs_add_inline_css_class( 'background-image: url(' . esc_url( $resurs_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( resurs_is_on( resurs_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight resurs-full-height';
	}
	$resurs_header_scheme = resurs_get_theme_option( 'header_scheme' );
	if ( ! empty( $resurs_header_scheme ) && ! resurs_is_inherit( $resurs_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $resurs_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $resurs_header_video ) ) {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( resurs_is_on( resurs_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'resurs_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
