<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package RESURS
 * @since RESURS 1.0
 */

$resurs_args = get_query_var( 'resurs_logo_args' );

// Site logo
$resurs_logo_type   = isset( $resurs_args['type'] ) ? $resurs_args['type'] : '';
$resurs_logo_image  = resurs_get_logo_image( $resurs_logo_type );
$resurs_logo_text   = resurs_is_on( resurs_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$resurs_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $resurs_logo_image['logo'] ) || ! empty( $resurs_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $resurs_logo_image['logo'] ) ) {
			if ( empty( $resurs_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($resurs_logo_image['logo']) && (int) $resurs_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$resurs_attr = resurs_getimagesize( $resurs_logo_image['logo'] );
				echo '<img src="' . esc_url( $resurs_logo_image['logo'] ) . '"'
						. ( ! empty( $resurs_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $resurs_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $resurs_logo_text ) . '"'
						. ( ! empty( $resurs_attr[3] ) ? ' ' . wp_kses_data( $resurs_attr[3] ) : '' )
						. '>';
			}
		} else {
			resurs_show_layout( resurs_prepare_macros( $resurs_logo_text ), '<span class="logo_text">', '</span>' );
			resurs_show_layout( resurs_prepare_macros( $resurs_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
