<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package RESURS
 * @since RESURS 1.0
 */

// Page (category, tag, archive, author) title

if ( resurs_need_page_title() ) {
	resurs_sc_layouts_showed( 'title', true );
	resurs_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								resurs_show_post_meta(
									apply_filters(
										'resurs_filter_post_meta_args', array(
											'components' => join( ',', resurs_array_get_keys_by_value( resurs_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', resurs_array_get_keys_by_value( resurs_get_theme_option( 'counters' ) ) ),
											'seo'        => resurs_is_on( resurs_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$resurs_blog_title           = resurs_get_blog_title();
							$resurs_blog_title_text      = '';
							$resurs_blog_title_class     = '';
							$resurs_blog_title_link      = '';
							$resurs_blog_title_link_text = '';
							if ( is_array( $resurs_blog_title ) ) {
								$resurs_blog_title_text      = $resurs_blog_title['text'];
								$resurs_blog_title_class     = ! empty( $resurs_blog_title['class'] ) ? ' ' . $resurs_blog_title['class'] : '';
								$resurs_blog_title_link      = ! empty( $resurs_blog_title['link'] ) ? $resurs_blog_title['link'] : '';
								$resurs_blog_title_link_text = ! empty( $resurs_blog_title['link_text'] ) ? $resurs_blog_title['link_text'] : '';
							} else {
								$resurs_blog_title_text = $resurs_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $resurs_blog_title_class ); ?>">
								<?php
								$resurs_top_icon = resurs_get_term_image_small();
								if ( ! empty( $resurs_top_icon ) ) {
									$resurs_attr = resurs_getimagesize( $resurs_top_icon );
									?>
									<img src="<?php echo esc_url( $resurs_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'resurs' ); ?>"
										<?php
										if ( ! empty( $resurs_attr[3] ) ) {
											resurs_show_layout( $resurs_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $resurs_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $resurs_blog_title_link ) && ! empty( $resurs_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $resurs_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $resurs_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'resurs_action_breadcrumbs' );
						$resurs_breadcrumbs = ob_get_contents();
						ob_end_clean();
						resurs_show_layout( $resurs_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
