<?php
/**
 * The template to display Admin notices
 *
 * @package RESURS
 * @since RESURS 1.0.64
 */

$resurs_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$resurs_skins_args = get_query_var( 'resurs_skins_notice_args' );
?>
<div class="resurs_admin_notice resurs_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$resurs_theme_img = resurs_get_file_url( 'screenshot.jpg' );
	if ( '' != $resurs_theme_img ) {
		?>
		<div class="resurs_notice_image"><img src="<?php echo esc_url( $resurs_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'resurs' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="resurs_notice_title">
		<?php esc_html_e( 'New skins are available', 'resurs' ); ?>
	</h3>
	<?php

	// Description
	$resurs_total      = $resurs_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$resurs_skins_msg  = $resurs_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $resurs_total, 'resurs' ), $resurs_total ) . '</strong>'
							: '';
	$resurs_total      = $resurs_skins_args['free'];
	$resurs_skins_msg .= $resurs_total > 0
							? ( ! empty( $resurs_skins_msg ) ? ' ' . esc_html__( 'and', 'resurs' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $resurs_total, 'resurs' ), $resurs_total ) . '</strong>'
							: '';
	$resurs_total      = $resurs_skins_args['pay'];
	$resurs_skins_msg .= $resurs_skins_args['pay'] > 0
							? ( ! empty( $resurs_skins_msg ) ? ' ' . esc_html__( 'and', 'resurs' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $resurs_total, 'resurs' ), $resurs_total ) . '</strong>'
							: '';
	?>
	<div class="resurs_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'resurs' ), $resurs_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="resurs_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $resurs_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'resurs' );
			?>
		</a>
	</div>
</div>
